const fs = require('fs');
const path = require('path');

const ORG_BASE = '/var/www/saas.gocrm.net/orgs';

function createProjectFolders({ organizationId, projectId }) {
  const base = path.join(
    ORG_BASE,
    `org_${organizationId}`,
    'project_files',
    `project_${projectId}`
  );

  const folders = ['images', 'docs'];

  folders.forEach(folder => {
    const dir = path.join(base, folder);
    if (!fs.existsSync(dir)) {
      fs.mkdirSync(dir, { recursive: true });
    }
  });
}

function deleteProjectFolders({ organizationId, projectId }) {
  const base = path.join(
    ORG_BASE,
    `org_${organizationId}`,
    'project_files',
    `project_${projectId}`
  );

  if (fs.existsSync(base)) {
    fs.rmSync(base, { recursive: true, force: true });
  }
}

module.exports = {
  createProjectFolders,
  deleteProjectFolders
};
