module.exports = function serializeMessage(row, { baseUrl }) {
  if (!row) return null;

  const isFile =
    row.isFile === true ||
    row.is_file === 1;

  let message = row.message || '';
  let isCode = false;

  /* ---------------------------
     CODE BLOCK DETECTION
  ---------------------------- */
  if (
    typeof message === 'string' &&
    message.startsWith('<code>') &&
    message.endsWith('</code>')
  ) {
    isCode = true;

    // Strip wrapper tags for clean rendering
    message = message
      .replace(/^<code>/, '')
      .replace(/<\/code>$/, '');
  }

  const filePath =
    row.filepath ||
    row.filePath ||
    null;

  return {
    id: row.id,

    senderId: row.senderId ?? row.sender_id ?? null,
    receiverId: row.receiverId ?? row.receiver_id ?? null,

    projectId: row.projectId ?? null,
    roomId: row.roomId ?? null,

    message,
    isFile,
    isCode,          // ✅ RESTORED FLAG
    filename: row.filename || null,
    isRead: row.is_read === 1,   // ✅ ADD THIS


    fileUrl: filePath
      ? `${baseUrl}${filePath}`
      : row.fileUrl || null,

    timestamp: row.timestamp
  };
};
