// utils/fileTypes.js
const allowedTypes = [
  // Images
  'image/jpeg',
  'image/png',
  'image/gif',
  'image/tiff',
  'image/svg+xml',
  'image/bmp',

  // Documents
  'application/pdf',
  'text/plain',
  'application/msword',
  'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
  'application/vnd.ms-excel',
  'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
  'text/csv',
  'application/vnd.ms-powerpoint',
  'application/vnd.openxmlformats-officedocument.presentationml.presentation',

  // Fonts
  'font/otf',
  'application/x-font-otf',

  // Archives
  'application/zip',
  'application/x-zip-compressed',
  'application/vnd.rar',
  'application/octet-stream',
  'application/x-rar-compressed',

  // Android APK
  'application/vnd.android.package-archive',

  // Audio
  'audio/mpeg',
  'audio/wav',

  // Video
  'video/mp4',

  // Design
  'image/vnd.adobe.photoshop',
  'application/postscript'
];

function isAllowedFileType(mimeType) {
  return allowedTypes.includes(mimeType);
}

module.exports = {
  allowedTypes,
  isAllowedFileType
};
