require('dotenv').config();
const nodemailer = require('nodemailer');

(async () => {
  try {
    console.log('🔍 SMTP CONFIG CHECK');
    console.log({
      host: process.env.SMTP_HOST,
      port: process.env.SMTP_PORT,
      user: process.env.SMTP_USER,
      from: process.env.EMAIL_FROM
    });

    const transporter = nodemailer.createTransport({
      host: process.env.SMTP_HOST,
      port: 465,
      secure: true, // ✅ REQUIRED FOR SSL (465)
      auth: {
        user: process.env.SMTP_USER,
        pass: process.env.SMTP_PASS
      },
      tls: {
        rejectUnauthorized: false // 🔧 OK for debugging
      },
      logger: true,
      debug: true
    });

    console.log('🔐 Verifying SMTP connection...');
    await transporter.verify();
    console.log('✅ SMTP connection verified');

    console.log('📨 Sending test email...');
    const info = await transporter.sendMail({
      from: process.env.EMAIL_FROM || process.env.SMTP_USER,
      to: process.env.SMTP_USER, // send to yourself
      subject: 'SMTP SSL Test (Port 465)',
      text: 'This is a test email sent via SSL SMTP on port 465.'
    });

    console.log('✅ Email sent successfully');
    console.log('Message ID:', info.messageId);

  } catch (err) {
    console.error('❌ SMTP TEST FAILED');
    console.error(err);
    process.exit(1);
  }
})();