// sockets/services/projectRoomMessageRepo.js

const pool = require('../../db');

async function insertRoomMessage({
  organizationId,
  projectId,
  roomId,
  sender_id,
  message,
  reply_to_id
}) {
  const [result] = await pool.query(
    `
    INSERT INTO project_room_messages
    (organizationId, projectId, roomId, sender_id, message, reply_to_id)
    VALUES (?, ?, ?, ?, ?, ?)
    `,
    [
      organizationId,
      projectId,
      roomId,
      sender_id,
      message,
      reply_to_id || null
    ]
  );

  const [rows] = await pool.query(
    `
    SELECT *
    FROM project_room_messages
    WHERE id = ?
    LIMIT 1
    `,
    [result.insertId]
  );

  return rows[0];
}

module.exports = {
  insertRoomMessage
};
