const pool = require('../../db');

/**
 * A user is allowed in a project room
 * if they belong to the project within the org.
 * Room === Project
 */
async function isUserInProjectRoom(userId, projectId, orgId) {
  const [rows] = await pool.query(
    `
    SELECT 1
    FROM project_users
    WHERE userId = ?
      AND projectId = ?
      AND organizationId = ?
    LIMIT 1
    `,
    [userId, projectId, orgId]
  );

  return rows.length > 0;
}

/**
 * Project archived = room archived
 */
async function isRoomArchived(projectId) {
  const [rows] = await pool.query(
    `
    SELECT isArchived
    FROM projects
    WHERE id = ?
    LIMIT 1
    `,
    [projectId]
  );

  return rows.length > 0 && rows[0].isArchived === 1;
}

module.exports = {
  isUserInProjectRoom,
  isRoomArchived
};
