
let io;

function initChatEvents({ ioInstance }) {
  io = ioInstance;
}

function emitFileMessage({ orgId, senderId, receiverId, fileData }) {
  const receiverSockets = onlineUsers.getSockets(orgId, receiverId);
  const senderSockets = onlineUsers.getSockets(orgId, senderId);

  receiverSockets.forEach(socketId => {
    io.to(socketId).emit('receive_file', {
      ...fileData,
      direction: 'received'
    });
  });

  senderSockets.forEach(socketId => {
    io.to(socketId).emit('receive_file', {
      ...fileData,
      direction: 'sent'
    });
  });
}

module.exports = {
  initChatEvents,
  emitFileMessage
};
