// sockets/projectRooms.socket.js
const { PROJECT_ROOM_EVENTS } = require('./projectRooms.events');

function projectRoom(orgId, projectId) {
  return `org:${orgId}:project:${projectId}`;
}

function registerProjectRoomSockets(io, socket) {
  const { orgId } = socket.user;

  socket.on(PROJECT_ROOM_EVENTS.ENTER, ({ projectId }) => {
    if (!projectId) return;

    const room = projectRoom(orgId, projectId);
    socket.join(room);

    console.log('[PROJECT ROOM JOIN]', socket.id, room);
  });

  socket.on(PROJECT_ROOM_EVENTS.LEAVE, ({ projectId }) => {
    if (!projectId) return;

    const room = projectRoom(orgId, projectId);
    socket.leave(room);

    console.log('[PROJECT ROOM LEAVE]', socket.id, room);
  });

  // 🚫 IMPORTANT:
  // No message sending here.
  // All messages go through chat.socket.js → send_message
}

module.exports = {
  registerProjectRoomSockets
};
