let io;

/* ============================================================
   INITIALIZER
============================================================ */
function initProjectEvents({ ioInstance }) {
  io = ioInstance;
}

/* ============================================================
   HELPERS
============================================================ */
function getProjectRoom(orgId, projectId) {
  return `org:${orgId}:project:${projectId}`;
}

/* ============================================================
   EMIT: FILE UPLOADED
============================================================ */
async function notifyProjectFileUpload({
  organizationId,
  projectId,
  uploaderId,
  filename,
  folderType
}) {
  if (!io) {
    console.warn('[projectEvents] io not initialized');
    return;
  }

  const room = getProjectRoom(organizationId, projectId);

  io.to(room).emit('proj_file_uploaded', {
    projectId,
    filename,
    folderType,
    uploaderId
  });

  console.log(
    `[PROJECT EVENT] file uploaded → ${room} → ${filename}`
  );
}

module.exports = {
  initProjectEvents,
  notifyProjectFileUpload
};
