class OnlineUsers {
  constructor() {
    // orgId -> Map(userId -> Set(socketId))
    this.orgs = new Map();
  }

  add(orgId, userId, socketId) {
    if (!this.orgs.has(orgId)) {
      this.orgs.set(orgId, new Map());
    }

    const users = this.orgs.get(orgId);

    if (!users.has(userId)) {
      users.set(userId, new Set());
    }

    users.get(userId).add(socketId);
  }

  remove(orgId, userId, socketId) {
    const users = this.orgs.get(orgId);
    if (!users) return;

    const sockets = users.get(userId);
    if (!sockets) return;

    sockets.delete(socketId);

    if (sockets.size === 0) {
      users.delete(userId);
    }

    if (users.size === 0) {
      this.orgs.delete(orgId);
    }
  }

  getSockets(orgId, userId) {
    const users = this.orgs.get(orgId);
    if (!users) return new Set();
    return users.get(userId) || new Set();
  }

  getOnlineUserIds(orgId) {
    const users = this.orgs.get(orgId);
    return users ? Array.from(users.keys()) : [];
  }

  isUserOnline(orgId, userId) {
    const users = this.orgs.get(orgId);
    return users ? users.has(userId) : false;
  }
}

module.exports = new OnlineUsers();
