// public/organization/verify-email/verify.js

const statusEl = document.getElementById('statusMessage');
const actionsEl = document.getElementById('actions');

const params = new URLSearchParams(window.location.search);
const token = params.get('token');

if (!token) {
  statusEl.textContent = 'Invalid verification link.';
} else {
  verifyToken(token);
}

async function verifyToken(token) {
  try {
    const res = await fetch(
      `${window.location.origin}/api/organization/verify-email?token=${encodeURIComponent(token)}`,
      {
        method: 'GET',
        headers: {
          'Accept': 'application/json'
        }
      }
    );

    const result = await res.json();

    if (!res.ok || !result.success) {
      statusEl.textContent =
        result.error || 'Verification failed or link expired.';
      return;
    }

    statusEl.textContent =
      'Your email has been verified successfully!';

    actionsEl.style.display = 'block';

  } catch (err) {
    console.error(err);
    statusEl.textContent =
      'Network error while verifying email.';
  }
}
