 // navigation script

 const carousel = document.getElementById('carousel');
    const navItems = document.querySelectorAll('.nav-item');

    //let currentIndex = 0;

    function updatecarousel(index) {
      currentIndex = index;
      carousel.style.transform = `translateX(-${index * 100}%)`;
      navItems.forEach(item => item.classList.remove('active'));
      navItems[index].classList.add('active');
    }

    navItems.forEach(item => {
      item.addEventListener('click', () => {
        const index = parseInt(item.getAttribute('data-index'));
        updatecarousel(index);
      });
    });

    // Touch support
    let startX = 0;
    let currentTranslate = 0;

    carousel.addEventListener('touchstart', (e) => {
      startX = e.touches[0].clientX;
    });

    carousel.addEventListener('touchend', (e) => {
      const endX = e.changedTouches[0].clientX;
      const deltaX = endX - startX;

      if (Math.abs(deltaX) > 50) {
        if (deltaX < 0 && currentIndex < 2) {
          currentIndex++;
        } else if (deltaX > 0 && currentIndex > 0) {
          currentIndex--;
        }
        updatecarousel(currentIndex);
      }
    });

    // Initialize to default
    updatecarousel(0);

    //end carousel navigation