document.getElementById('loginForm').addEventListener('submit', async (e) => {
  e.preventDefault();

  const email = document.getElementById('email').value.trim();
  const password = document.getElementById('password').value;

  const res = await fetch('/login', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ email, password })
  });

  const data = await res.json();

  if (!data.success) {
    alert(data.error || 'Login failed');
    return;
  }

  if (!['owner', 'admin'].includes(data.user.role)) {
    alert('Access denied');
    return;
  }

  localStorage.setItem('token', data.token);
  window.location.href = '/dashboard/';
});
